-----------Disa System Main Functions Part--------------
-----------Written by Carluz 2014/4--------------
-----------Please contact me if you want to use this.--------------

--------------------GUI functions-----------------------------
local iconposx=22;
local iconposy=110;
local ItemPath = "Themes/".. THEME:GetThemeDisplayName() .."/AvaliableItems/"

function GetFlashAlpha()
	local sbt =GAMESTATE:GetSongPosition():GetSongBeat()
	local bt= math.ceil(sbt)
	local result = bt-sbt
	return result;
end;

function GetTitlePath(song)
	local path  =  song:GetSongDir()
	if FILEMAN:DoesFileExist(path.."title.png") then
		return path.."title.png"
	end
	return nil
end;

function HasTitle(song)
	local tp  =  GetTitlePath(song)
	if tp then
		return true
	else
		return false
	end;
end;

function CheckFallbackTitlePath(song)
	local fallbackPath="Themes/".. THEME:GetThemeDisplayName() .."/Fallbacks/"
	local songgroup=song:GetGroupName()
	local songdir=song:GetSongDir()
	local filelist=FILEMAN:GetDirListing(songdir)
	for i=1, #filelist do
		local name=filelist[i]
			if string.find(name,".ssc") then
				name=string.gsub(name,".ssc","");
				if FILEMAN:DoesFileExist(fallbackPath..songgroup.."/"..name.."title.png") then
					return fallbackPath..songgroup.."/"..name.."title.png"
				end;
			elseif string.find(name,".sm") then
				name=string.gsub(name,".sm","");
				if FILEMAN:DoesFileExist(fallbackPath..songgroup.."/"..name.."title.png") then
					return fallbackPath..songgroup.."/"..name.."title.png"
				end;
			end;
	end;
	--Well,we need a huge fallback package now.
	return nil
end;

function GetGroupJacketPath(song)
	local path  =  song:GetSongDir()
	if FILEMAN:DoesFileExist(path.."../jacket.png") then
		return path.."../jacket.png"
	elseif FILEMAN:DoesFileExist(path.."../jacket.jpg") then
		return path.."../jacket.jpg"
	end
	return nil
end;

function GetGroupTitlePath(song)
	local path  =  song:GetSongDir()
	if FILEMAN:DoesFileExist(path.."../title.png") then
		return path.."../title.png"
	elseif FILEMAN:DoesFileExist(path.."../title.jpg") then
		return path.."../title.jpg"
	elseif FILEMAN:DoesFileExist(path.."../title.bmp") then
		return path.."../title.bmp"
	end
	return nil
end;

-------------------------Draw functions-----------------------------
function DrawLine(length,width)
	local t=Def.ActorFrame{
		Def.Quad{
			InitCommand=cmd(diffuse,color("#000000");diffusealpha,0.6;zoomto,length,width+4;fadetop,0.1;fadebottom,0.1);
		};
		Def.Quad{
			InitCommand=cmd(diffuse,color("#FFFFFF");zoomto,length,width;);
		};
	};
	return t;
end;

function DrawStandByOverlay()
	local t=Def.ActorFrame{
		Def.Quad {
			InitCommand=cmd(Center;diffuse,color("#000000")zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffusealpha,0;);
			OnCommand=cmd(playcommand,"Set";);
			SetCommand=function(self)
				self:stoptweening();
				if HOOKS:AppHasFocus() then
					self:linear(0.2);
					self:diffusealpha(0);
				else
					self:linear(0.2);
					self:diffusealpha(0.8);
					SCREENMAN:GetTopScreen():lockinput(0.4)
				end;
				self:queuecommand("Set");
			end;
		};
		LoadFont("Common normal") .. {
			Text="Stand By...";
			OnCommand=cmd(zoomy,1.6;zoomx,2;skewx,-0.1;Center;strokecolor,color("#000000");playcommand,"Set";diffusealpha,0;);
			SetCommand=function(self)
				self:stoptweening();
				if HOOKS:AppHasFocus() then
					self:linear(0.2);
					self:diffusealpha(0);
				else
					self:linear(0.2);
					self:diffusealpha(1);
				end;
				self:queuecommand("Set");
			end;
		};
	};
	return t;
end;
-------------------------System functions----------------------------
function LayoutGroupNames2()
	local songgroups=SONGMAN:GetSongGroupNames();
	local s1=0
	local t=Def.ActorFrame{};
	for i=1,#songgroups do
		t[#t+1] =LoadFont("Common normal") .. {
			Text=songgroups[s1];
			InitCommand=cmd(y,s1*20);
		};
		s1=s1+1;
	end;
	return t;
end;
-----I don't know why doesn't this work.

function CuSong()
	return GAMESTATE:GetCurrentSong();
end;

function CuSec()
	return GAMESTATE:GetSongPosition():GetMusicSeconds();
end;

function CuBt()
	return GAMESTATE:GetSongPosition():GetSongBeat();
end;

function CuCourse()
	return GAMESTATE:GetCurrentCourse();
end;

function Actor:scale_or_crop_background()
	local gw = self:GetWidth()
	local gh = self:GetHeight()
	local graphicAspect = gw/gh
	local displayAspect = DISPLAY:GetDisplayWidth()/DISPLAY:GetDisplayHeight()

	if (GetUserPref("GameplayBackground")=='Cover') then
		self:scaletocover( 0,0,SCREEN_WIDTH,SCREEN_HEIGHT );
	else
		self:scaletofit( 0,0,SCREEN_WIDTH,SCREEN_HEIGHT );
	end;

end;

function FullcomboType(pn)
	local pss=STATSMAN:GetCurStageStats():GetPlayerStageStats(pn);
	local radar=steps:GetRadarValues(pn);
	local w1=pss:GetTapNoteScores('TapNoteScore_W1');
		--flawless
	local w2=pss:GetTapNoteScores('TapNoteScore_W2');
		--perfect
	local w3=pss:GetTapNoteScores('TapNoteScore_W3');
		--great
	local w4=pss:GetTapNoteScores('TapNoteScore_W4');
		--good
	local w5=pss:GetTapNoteScores('TapNoteScore_W5');
		--boo
	local hd=pss:GetHoldNoteScores('HoldNoteScore_Held');
	local letgo=pss:GetHoldNoteScores('HoldNoteScore_LetGo');
		--holds
	if letgo+w5+w4==0 then
		if w3+w2==0 and w1>=0 then
			return "flawless"
		elseif w3==0 and w2+w1>=0 then
			return "perfect"
		elseif w3==0 and w2+w1==0 then
			return "great"
		else
			return "fullcombo"
		end;
	else
		return "notfullcombo"
	end;
end;

function GetDisa(nm)
	local Disa={
		exist=true,
		name="Disa System",
		version="v1.0"
	};	
	return Disa[nm];
end;

function GetDisaPoints()
	return tonumber(GetUserPref("DisaPoints"))
end